// 8Connection.h: interface for the C8Connection class.
//
//////////////////////////////////////////////////////////////////////

#if !defined(AFX_8CONNECTION_H__4821C4C7_82BA_4E94_AEA7_CE4D49E80F0B__INCLUDED_)
#define AFX_8CONNECTION_H__4821C4C7_82BA_4E94_AEA7_CE4D49E80F0B__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000


#include	"8PKPool.h"

#include	"misc.h"


// iocp  ÷
#define		OP_READ					0
#define		OP_WRITE				1
#define		OP_ACCEPT				2


class C8Connection  
{
public:
	C8Connection();

public:
	BOOL				Create(	DWORD		dwIndex,
								SOCKET		listener,
								C8PKPool*	pPKPool );
	BOOL				Open();
	BOOL				Close( LPOVERLAPPEDPLUS lpOverlapPlus, BOOL bForce=FALSE );
	BOOL				Shutdown( LPOVERLAPPEDPLUS lpOverlapPlus, BOOL bForce=FALSE );
	BOOL				DoIo( LPOVERLAPPEDPLUS lpOverlapPlus );


protected:
	sockaddr_in			m_local;
	sockaddr_in			m_peer;

	C8PKPool*			m_pPKPool;

	//
	SOCKET				m_listener;
	SOCKET				m_socket;

	// for debug
	DWORD				m_dwIndex;

	//
	LPOVERLAPPEDPLUS	PrepareAcptPacket();
	LPOVERLAPPEDPLUS	PrepareRecvPacket( char *pbuf, UINT buflen );
	LPOVERLAPPEDPLUS	PrepareSendPacket( char *pbuf, UINT buflen );
	//
	BOOL				ReleaseAcptPacket( LPOVERLAPPEDPLUS lpOverlapPlus );
	BOOL				ReleaseRecvPacket( LPOVERLAPPEDPLUS lpOverlapPlus );
	BOOL				ReleaseSendPacket( LPOVERLAPPEDPLUS lpOverlapPlus );

	//
	BOOL				BindIOCP( LPOVERLAPPEDPLUS lpOverlapPlus );

	//
	BOOL				SendPost( char *pbuf, UINT buflen );
	BOOL				RecvPost( char *pbuf=NULL, UINT buflen=0 );

	//
	int					DispatchPacket( LPOVERLAPPEDPLUS lpOverlapPlus );


public:
	~C8Connection();
};

#endif // !defined(AFX_8CONNECTION_H__4821C4C7_82BA_4E94_AEA7_CE4D49E80F0B__INCLUDED_)

